/*
 * Decompiled with CFR 0.152.
 */
package Data_Structures.Structures;

import Data_Structures.ADTs.Deque;
import Data_Structures.ADTs.Pairable;
import Data_Structures.ADTs.Queue;
import Data_Structures.ADTs.Stack;
import Data_Structures.Operations.Sort;
import Data_Structures.Structures.Data_Structure;
import Data_Structures.Structures.HashingClasses.Set;
import Data_Structures.Structures.IterB;
import Data_Structures.Structures.Pair;
import java.util.Iterator;
import util.Genarics;

public class List<E>
extends Data_Structure<E>
implements Pairable<E>,
Stack<E>,
Queue<E>,
Deque<E> {
    private Node first;
    private Node last;
    private int size = 0;
    Genarics<E> ge_e = new Genarics();

    public List() {
    }

    public List(E ... data) {
        this.append(data);
    }

    @Override
    public void push(E elem) {
        Node n = new Node();
        n.elem = elem;
        if (this.isEmpty()) {
            this.first = n;
            this.last = n;
            ++this.size;
            return;
        }
        n.prev = this.last;
        this.last.next = n;
        this.last = n;
        ++this.size;
    }

    @Override
    public E pop() {
        if (this.isEmpty()) {
            throw new Error("ERROR: List: cannot pop from empty list!");
        }
        --this.size;
        Node output = this.last;
        this.last = this.last.prev;
        if (this.last != null) {
            this.last.next = null;
        } else {
            this.first = null;
        }
        return output.elem;
    }

    @Override
    public void enq(E elem) {
        this.push(elem);
    }

    @Override
    public E deq() {
        if (this.isEmpty()) {
            throw new Error("ERROR: List: cannot deq from empty list!");
        }
        --this.size;
        Node output = this.first;
        this.first = this.first.next;
        if (this.first != null) {
            this.first.prev = null;
        } else {
            this.last = null;
        }
        return output.elem;
    }

    @Override
    public void add(E elem) {
        this.push(elem);
    }

    public E rem() {
        return this.pop();
    }

    public boolean remove(E elem) {
        IterB<E> iter2 = this.getIter();
        while (iter2.hasNext()) {
            E e = iter2.next();
            if (!e.equals(elem)) continue;
            iter2.remove();
            return true;
        }
        return false;
    }

    public void prepend(E elem) {
        Node n = new Node();
        n.elem = elem;
        if (this.isEmpty()) {
            this.first = n;
            this.last = n;
            ++this.size;
            return;
        }
        n.next = this.first;
        this.first.prev = n;
        this.first = n;
        ++this.size;
    }

    public void reverse() {
        E[] data = this.toArray();
        this.clear();
        E[] EArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            Object e = EArray[n2];
            this.prepend(e);
            ++n2;
        }
    }

    public void sort() {
        if (this.isEmpty()) {
            return;
        }
        Comparable[] A = this.toComparableArray();
        Sort.msort(A);
        this.clear();
        this.append(A);
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public E getFirst() {
        if (this.isEmpty()) {
            return null;
        }
        return this.first.elem;
    }

    @Override
    public E getLast() {
        if (this.isEmpty()) {
            return null;
        }
        return this.last.elem;
    }

    public Comparable<E>[] toComparableArray() {
        if (this.isEmpty()) {
            return null;
        }
        Comparable<E>[] output = this.ge_e.Comparable_Array(this.size);
        Node n = this.first;
        int i = 0;
        while (n != null && i < this.size) {
            output[i] = (Comparable)n.elem;
            n = n.next;
            ++i;
        }
        return output;
    }

    @Override
    public List<E> clone() {
        List<E> other = new List<E>();
        for (E elem : this) {
            other.add(elem);
        }
        return other;
    }

    public void clear() {
        this.first = null;
        this.last = null;
        this.size = 0;
    }

    public IterB<E> getIter() {
        Node temp = new Node();
        temp.next = this.first;
        return new iter(temp);
    }

    public IterB<E> getTailIter() {
        Node temp = new Node();
        temp.prev = this.last;
        return new iter(temp);
    }

    @Override
    public Iterator<E> iterator() {
        return this.getIter();
    }

    @Override
    public String toString() {
        StringBuilder output = new StringBuilder();
        output.append("List [Size = " + this.size + "]\n");
        if (this.isEmpty()) {
            return output + "[Empty]";
        }
        Node n = this.first;
        while (n != null) {
            output.append(n.elem + " <-->\n");
            n = n.next;
        }
        output.append("[End of List]");
        return output.toString();
    }

    @Override
    public E peep_back() {
        return this.getLast();
    }

    @Override
    public E peep_front() {
        return this.getFirst();
    }

    @Override
    public E pop_back() {
        return this.pop();
    }

    @Override
    public E pop_front() {
        return this.deq();
    }

    @Override
    public void push_back(E elem) {
        this.push(elem);
    }

    @Override
    public void push_front(E elem) {
        this.prepend(elem);
    }

    @Override
    public E top() {
        return this.getLast();
    }

    @Override
    public E peek() {
        return this.getFirst();
    }

    @Override
    public Queue<E> enq_static(E elem) {
        throw new Error("Not Implemented");
    }

    @Override
    public Pair<E, Queue<E>> deq_static() {
        throw new Error("Not Implemented");
    }

    @Override
    public Stack<E> push_static(E elem) {
        throw new Error("Not Implemented");
    }

    @Override
    public Pair<E, Stack<E>> pop_static() {
        throw new Error("Not Implemented");
    }

    public List<E> removeNulls() {
        Iterator<E> iter2 = this.iterator();
        while (iter2.hasNext()) {
            if (iter2.next() != null) continue;
            iter2.remove();
        }
        return this;
    }

    public List<E> removeDuplicates() {
        Set<E> set = new Set<E>();
        Iterator<E> iter2 = this.iterator();
        while (iter2.hasNext()) {
            E elem = iter2.next();
            if (set.includes(elem)) {
                iter2.remove();
                continue;
            }
            set.set_add(elem);
        }
        return this;
    }

    public void destructiveAppend(List<E> other) {
        if (other.isEmpty()) {
            return;
        }
        if (this.isEmpty()) {
            this.first = other.first;
            this.last = other.last;
            this.size = other.size;
            return;
        }
        this.last.next = other.first;
        other.first.prev = this.last;
        this.last = other.last;
        this.size += other.size;
    }

    private class Node {
        Node prev;
        Node next;
        E elem;

        private Node() {
        }
    }

    private class iter
    implements IterB<E> {
        private Node current_node;
        private boolean has_current = false;

        public iter(Node n) {
            this.current_node = n;
        }

        @Override
        public boolean hasNext() {
            if (this.current_node == null) {
                return false;
            }
            return this.current_node.next != null;
        }

        @Override
        public E next() {
            this.current_node = this.current_node.next;
            this.has_current = true;
            return this.current_node.elem;
        }

        @Override
        public boolean hasPrevious() {
            return this.current_node.prev != null;
        }

        @Override
        public E previous() {
            this.has_current = true;
            this.current_node = this.current_node.prev;
            return this.current_node.elem;
        }

        @Override
        public void remove() {
            if (!this.has_current) {
                throw new Error("Iteration must take place before removal.");
            }
            this.has_current = false;
            Node prev = this.current_node.prev;
            Node next = this.current_node.next;
            if (prev != null) {
                prev.next = next;
            }
            if (next != null) {
                next.prev = prev;
            }
            if (this.current_node == List.this.first) {
                List.this.first = next;
            }
            if (this.current_node == List.this.last) {
                List.this.last = prev;
            }
            this.current_node.elem = null;
            List list = List.this;
            list.size = list.size - 1;
        }

        @Override
        public void replace(E elem) {
            if (!this.has_current) {
                throw new Error("Iteration must take place before a replacement.");
            }
            this.current_node.elem = elem;
        }

        @Override
        public void insertBefore(E elem) {
            if (!this.has_current) {
                List.this.add(elem);
                this.current_node = List.this.first;
                this.has_current = true;
                return;
            }
            Node node_new = new Node();
            node_new.elem = elem;
            Node prev = this.current_node.prev;
            Node next = this.current_node;
            node_new.prev = prev;
            node_new.next = next;
            if (prev != null) {
                prev.next = node_new;
            }
            if (next != null) {
                next.prev = node_new;
            }
            if (this.current_node == List.this.first) {
                List.this.first = node_new;
            }
            List list = List.this;
            list.size = list.size + 1;
            this.current_node = node_new;
        }

        @Override
        public void insertAfter(E elem) {
            Node prev;
            if (!this.has_current) {
                List.this.add(elem);
                this.current_node = List.this.first;
                this.has_current = true;
                return;
            }
            Node node_new = new Node();
            node_new.elem = elem;
            Node next = this.current_node.next;
            node_new.prev = prev = this.current_node;
            node_new.next = next;
            if (next != null) {
                next.prev = node_new;
            }
            if (prev != null) {
                prev.next = node_new;
            }
            if (this.current_node == List.this.last) {
                List.this.last = node_new;
            }
            List list = List.this;
            list.size = list.size + 1;
            this.current_node = node_new;
        }

        @Override
        public E current() {
            return this.current_node.elem;
        }

        @Override
        public boolean hasCurrent() {
            return this.has_current;
        }

        @Override
        public Object clone() {
            iter output = new iter(this.current_node);
            output.has_current = this.has_current;
            return output;
        }

        @Override
        public boolean equals(Object o) {
            iter other = (iter)o;
            return other.current_node == this.current_node;
        }
    }
}

